/* ### Transitions between Sections ##################################################################### */
(function() {
	// detect if IE : from http://stackoverflow.com/a/16657946		
	var ie = (function(){
		var undef,rv = -1; // Return value assumes failure.
		var ua = window.navigator.userAgent;
		var msie = ua.indexOf('MSIE ');
		var trident = ua.indexOf('Trident/');

		if (msie > 0) {
			// IE 10 or older => return version number
			rv = parseInt(ua.substring(msie + 5, ua.indexOf('.', msie)), 10);
		} else if (trident > 0) {
			// IE 11 (or newer) => return version number
			var rvNum = ua.indexOf('rv:');
			rv = parseInt(ua.substring(rvNum + 3, ua.indexOf('.', rvNum)), 10);
		}

		return ((rv > -1) ? rv : undef);
	}());


	// disable/enable scroll (mousewheel and keys) from http://stackoverflow.com/a/4770179					
	// left: 37, up: 38, right: 39, down: 40,
	// spacebar: 32, pageup: 33, pagedown: 34, end: 35, home: 36
	var keys = [32, 37, 38, 39, 40], wheelIter = 0;

	function viewport() {
		var e = window, a = 'inner';
		if (!('innerWidth' in window )) {
			a = 'client';
			e = document.documentElement || document.body;
		}
		return { width : e[ a+'Width' ] , height : e[ a+'Height' ] };
	}
	
	/*
	bviewport = viewport();
		ratio = bviewport.width / bviewport.height;
	*/
	
	function preventDefault(e) {
		e = e || window.event;
		if (e.preventDefault)
		e.preventDefault();
		e.returnValue = false;  
	}

	function keydown(e) {
		for (var i = keys.length; i--;) {
			if (e.keyCode === keys[i]) {
				preventDefault(e);
				return;
			}
		}
	}

	function touchmove(e) {
		preventDefault(e);
	}

	function wheel(e) {
		// for IE 
		if( ie ) {
			jQuery(function($) {
				//if( jQuery('body').hasClass('index-single') )
					$('body').addClass('bie');
			});
			//preventDefault(e);
		}
	}

	function disable_scroll() {
		bviewport = viewport();
		if( bviewport.width > 767 && !isIpad() ){
			window.onmousewheel = document.onmousewheel = wheel;
			document.onkeydown = keydown;
			document.body.ontouchmove = touchmove;
		}
	}

	function enable_scroll() {
		window.onmousewheel = document.onmousewheel = document.onkeydown = document.body.ontouchmove = null;  
	}

	var docElem = window.document.documentElement,
		scrollVal,
		isRevealed, 
		noscroll, 
		isAnimating,
		container = document.getElementById( 'container' ),
		trigger = container.querySelector( 'button.trigger' );
		trigger_up = container.querySelector( 'div.top' );

	function scrollY() {
		return window.pageYOffset || docElem.scrollTop;
	}

	function scrollToTitle(){
		var elm = document.getElementById('title');
		var stopY = elm.offsetTop - 20;
		var startY = 0;
		var distance = stopY > startY ? stopY - startY : startY - stopY;
		var speed = 20;
		var step = Math.round(distance / 25);
		var leapY = stopY > startY ? startY + step : startY - step;
		var timer = 0;
		bviewport = viewport();
		if( bviewport.width > 767 && !isIpad() ){
			if (stopY > startY) {			
				for ( var i=startY; i<stopY; i+=step ) {
					console.log(leapY);
					setTimeout("window.scrollTo(0, "+leapY+")", timer * speed);
					leapY += step; if (leapY > stopY) leapY = stopY; timer++;
				}
			}
		}
	}
	
	function isIpad(){
		/*bviewport = viewport();
		console.log( bviewport );
		if( (bviewport.width == 1024 && bviewport.height == 768)  || (bviewport.width == 768 && bviewport.height == 1024) )
			return true;
		else
			return false;*/
		//var iOS = /(iPad)/g.test(navigator.userAgent);
		//return iOS;
		var useragent = navigator.userAgent;
		console.log( useragent );
		if(useragent.match(/iPad/i))
			return true;
		else
			return false;
	}
	
	function scrollPage() {
		scrollVal = scrollY();
		
		bviewport = viewport();
		
		if( noscroll && !ie && bviewport.width > 767 && !isIpad() ) {
			if( scrollVal < 0 ) return false;
			// keep it that way
			window.scrollTo( 0, 0 );
		}

		if( classie.has( container, 'notrans' ) ) {
			classie.remove( container, 'notrans' );
			return false;
		}

		if( isAnimating ) {
			return false;
		}
		
		if( scrollVal <= 0 && isRevealed && !trigger_up ) {
			toggle(0);
		}
		else if( scrollVal > 0 && !isRevealed ){
			toggle(1);
		}
	}

	function toggle_up(){
		if( scrollVal <= 0 && isRevealed ) {
			toggle(0);
		}
	}

	function toggle( reveal ) {
		isAnimating = true;
		if( reveal ) {
			classie.add( container, 'modify' );			
		}
		else {
			noscroll = true;
			disable_scroll();
			classie.remove( container, 'modify' );
			
			jQuery(function($) {
				if( jQuery('body').hasClass('bie') )
					$('body').removeClass('bie');
			});
		}

		//simulating the end of the transition:
		setTimeout( function() {
			isRevealed = !isRevealed;
			isAnimating = false;
			if( reveal ) {
				noscroll = false;
				enable_scroll();
				
			}
		}, 600 );
	}

	// refreshing the page...
	var pageScroll = scrollY();
	noscroll = pageScroll === 0;
	
	disable_scroll();
	
	if( pageScroll ) {
		isRevealed = true;
		classie.add( container, 'notrans' );
		classie.add( container, 'modify' );
	}
	
	if (trigger_up) {
		trigger_up.addEventListener( 'click', toggle_up );
	}
	window.addEventListener( 'scroll', scrollPage );
	trigger.addEventListener( 'click', function() { toggle( 'reveal' ); } );
})();