// JavaScript Document
jQuery(document).ready(function($){
	window.$ = jQuery;

	// Scroll to top when logo clicked
	$('.logo').click(function() {
		$(window).scrollTo(0, 800);
	});

	//STICKY HEADER

	$(window).scroll(function () {
		if($(document).scrollTop()>40){
			$('#main-header').addClass('headerfixed');
		} else {
			$('#main-header').removeClass('headerfixed');
		}
	});

	$('#menu-btn').click(function() {
		if ($('#container').hasClass('menuopen')) {
			$(this).removeClass('active');
			$('#container').removeClass('menuopen');
			$('#mobile-nav').removeClass('menuopen');
		} else {
			$(this).addClass('active');
			$('#container').addClass('menuopen');
			$('#mobile-nav').addClass('menuopen');
		}
	});

	// Scroll to each section on navigation click
	$('#main-nav li').click(function() {
		var scroller = $('#main-nav li').index($(this)) + 1;
		$(window).scrollTo($('#container section:nth-child('+scroller+')'), 800, {offset: -83});
	});
	$('#mobile-nav li').click(function() {
		var scroller = $('#mobile-nav li').index($(this)) + 1;
		$(window).scrollTo($('#container section:nth-child('+scroller+')'), 800, {offset: -50});
		$('#container').removeClass('menuopen');
		$('#mobile-nav').removeClass('menuopen');
		$('#menu-btn').removeClass('active');
	});

	$('.health').click(function() {
		$(window).scrollTo($('#community-outreach-health'), 800, {offset: -83});
	});
	$('.education').click(function() {
		$(window).scrollTo($('#community-outreach-education'), 800, {offset: -83});
	});
	$('.housing').click(function() {
		$(window).scrollTo($('#community-outreach-housing'), 800, {offset: -83});
	});
	$('.finance').click(function() {
		$(window).scrollTo($('#community-outreach-finance'), 800, {offset: -83});
	});
	$('#allinitbtn').click(function() {
		$(window).scrollTo($('#all-initiatives'), 800, {offset: -83});
	});


	// Apply active class to nav items while scrolling
	var sections = $('section');
	var nav = $('#main-nav');
	var nav_height = nav.outerHeight();

	$(window).on('scroll', function () {
	  var cur_pos = $(this).scrollTop();

	  sections.each(function() {
		var top = $(this).offset().top - nav_height,
			bottom = top + $(this).outerHeight();

		if (cur_pos >= top && cur_pos <= bottom) {
		  nav.find('a').removeClass('active');
		  sections.removeClass('active');

		  $(this).addClass('active');
		  nav.find('a[href="#'+$(this).attr('id')+'"]').addClass('active');
		}
	  });
	});
	// Apply active class to nav items when clicked
	nav.find('a').on('click', function () {
		var $el = $(this);
		var id = $el.attr('href');

	  $('html, body').animate({
			scrollTop: $(id).offset().top - nav_height
	  }, 500);

	  return false;
	});
	// Apply active class to last nav item when reaching end of page
	$(window).scroll(function() {
	   if($(window).scrollTop() + $(window).height() == $(document).height()) {
		   nav.find('a').removeClass('active');
		   sections.removeClass('active');
		   $('.learn-more-nav').addClass('active');
	   }
	});

});
